//Tub surround tile inc file

#declare R1 = seed(26472);
#declare R2 = seed(1971);

#declare TTex = texture {
                 pigment
                 {granite
                 turbulence 0.6 
                 color_map
                 {[0.000, 0.178   color rgbt <0.804, 0.569, 0.494, 0.000>
                 color rgbt <0.816, 0.725, 0.537, 0.400>]
                 [0.178, 0.356   color rgbt <0.816, 0.725, 0.537, 0.000>
                 color rgbt <0.820, 0.580, 0.522, 0.000>]
                 [0.356, 0.525   color rgbt <0.820, 0.580, 0.522, 0.000>
                 color rgbt <0.882, 0.725, 0.537, 0.000>]
                 [0.525, 0.729   color rgbt <0.882, 0.725, 0.537, 0.000>
                 color rgbt <0.855, 0.729, 0.584, 0.000>]
                 [0.729, 1.001   color rgbt <0.855, 0.729, 0.584, 0.000>
                 color rgbt <0.804, 0.569, 0.494, 0.000>]
                }
        }
 }
#declare BTile = box { <-2.85,-.25,-2.85> <2.85,0,2.85> } //tile


//Tub tiles
#declare TubTiles = union {
//Lower vertical tile pattern
        union{
        #declare NrX = 0;     // start x
        #declare EndNrX = 21; // end   x
        #while (NrX< EndNrX) 
        // inner loop
        #declare NrY = 0;     // start y
        #declare EndNrY = 4; // end   y
        #while (NrY< EndNrY) 
     
        object{BTile texture { TTex rotate<rand(R2)*180,rand(R1)*180,0> scale <6,1,6> }
                                rotate<90,0,0> translate<NrX*6+3, NrY*6+3, 72> }  

    #declare NrY = NrY + 1;  // next Nr y
    #end // --------------- end of loop y
 #declare NrX = NrX + 1;  // next Nr x
 #end // --------------- end of loop x
 } 
//Upper vertical tile pattern
        union{
        #declare NrX = 0;     // start x
        #declare EndNrX = 6; // end   x
        #while (NrX< EndNrX) 
        // inner loop
        #declare NrY = 4;     // start y
        #declare EndNrY = 6; // end   y
        #while (NrY< EndNrY) 
     
        object{BTile texture { TTex rotate<rand(R2)*180,rand(R1)*180,0> scale <6,1,6> }
                                rotate<90,0,0> translate<NrX*6+3, NrY*6+3, 72> }  

    #declare NrY = NrY + 1;  // next Nr y
    #end // --------------- end of loop y
 #declare NrX = NrX + 1;  // next Nr x
 #end // --------------- end of loop x
 }  
//Vertical wall tile pattern
        union{
        #declare NrZ = 0;     // start z
        #declare EndNrZ = 6; // end   z
        #while (NrZ< EndNrZ) 
        // inner loop
        #declare NrY = 4;     // start y
        #declare EndNrY = 6; // end   y
        #while (NrY< EndNrY) 
     
        object{BTile texture { TTex rotate<rand(R2)*180,rand(R1)*180,0> scale <6,1,6> }
                                rotate<0,0,90> translate<36, NrY*6+3, 72+NrZ*6+3> }  

    #declare NrY = NrY + 1;  // next Nr y
    #end // --------------- end of loop y
 #declare NrZ = NrZ + 1;  // next Nr Z
 #end // --------------- end of loop Z
 }   
//Top of tub tile
        difference {
        union{
        #declare NrX = 6;     // start x
        #declare EndNrX = 21; // end   x
        #while (NrX< EndNrX) 
        // inner loop
        #declare NrZ = 0;     // start z
        #declare EndNrZ = 6; // end   z
        #while (NrZ< EndNrZ) 
     
        object {BTile texture { TTex rotate<rand(R2)*180,rand(R1)*180,0> scale <6,1,6> }
                                translate<NrX*6+3, 24, 72+NrZ*6+3> }

    #declare NrZ = NrZ + 1;  // next Nr z
    #end // --------------- end of loop z
 #declare NrX = NrX + 1;  // next Nr x
 #end // --------------- end of loop x
  }
 box { <46,2,76> <118,25,104> }
 }
 
}